//
//  LRFExpressions.h
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-03-14.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//  Additional copyright information found at http://littlerobotfriends.com/legal/
//

#ifndef __LRF_EXPRESSIONS_H
#define __LRF_EXPRESSIONS_H

#include "../lrf_constants.h"
#include "data/lrf_expression_data.h"
#include "data/lrf_song_data.h"
#include "types/lrf_types.h"
#include "lrf_eyes.h"
#include "lrf_speech.h"
#include "lrf_events.h"

#ifdef __cplusplus
extern "C" {
#endif

#define LRF_EXPRESSIONS_DEBUG_VERBOSE				false

#define LRF_EXPRESSIONS_SHIFT_OCTAVES_BY_FACE 	false

#define LRF_EXPRESSIONS_DEBUG								0
#define LRF_EXPRESSIONS_CALLBACK_DEBUG			0

#define LRF_EXPRESSIONS_WHITELIST_COUNT			5
#define LRF_EXPRESSION_RUN_DELAY						3

#define LRF_EYES_TIMER_RELOAD								3

typedef enum
{
	LRFExpressionState_Idle = 0,
	LRFExpressionState_Ready,
	LRFExpressionState_Running,
	LRFExpressionState_Finishing,
	LRFExpressionState_Done = 0xFF
} LRFExpressionState;

typedef enum {
	LRFExpressiveEyesState_Off = 0,
  LRFExpressiveEyesState_Normal,
  LRFExpressiveEyesState_Blinking,
  LRFExpressiveEyesState_Sleepy,
  LRFExpressiveEyesState_Excited
} LRFExpressiveEyesState;

typedef struct
{
	LRFExpressionState			state;
	LRFExpressionName			current;
	LRFExpressionName			next;
	bool									blockingByDefault;

	bool										eyesEnabled;
	LRFExpressiveEyesState	eyesState;

	LRFFunctionPtr				callback;
	LRFFunctionPtr				callbackWhitelist[LRF_EXPRESSIONS_WHITELIST_COUNT];

	unsigned char				signatureIdx;

	unsigned char				soundIdx;
	unsigned char				soundCount;

	unsigned long				startTime;
	unsigned int				duration;

	unsigned char				eyesTimer;

	uint16_t 							lastSongSessionId;

	LRFPattern					pattern;
	LRFSound					*sounds;		// saved pointers to passed sounds
	LRFSound					soundData[4];
} LRFExpressions_t;

extern LRFExpressions_t lrf_expressions;

void lrf_expressions_init(void);
void lrf_expressions_run(void);

// Non-Blocking expressions
void lrf_expressions_blinkAndSay(LRFExpression *expression, LRFFunctionPtr callback=NULL);
void lrf_expressions_blinkAndSayPreset(LRFExpressionName name, LRFFunctionPtr callback=NULL);
void lrf_expressions_blinkPatternAndSaySounds(LRFPattern pattern, LRFSound *sounds, unsigned char soundCount, LRFFunctionPtr callback=NULL);

// Blocking expressions
void lrf_expressions_blinkAndSayBlocking(LRFExpression *expression);
void lrf_expressions_blinkAndSayPresetBlocking(LRFExpressionName name);
void lrf_expressions_blinkPatternAndSaySoundsBlocking(LRFPattern pattern, LRFSound *sounds, unsigned char soundCount);

// Chatting, singing & other things
void lrf_expressions_chatter(void);
void lrf_expressions_sing(LRFSong *song);

// Expressive eyes
void lrf_expressions_enableExpressiveEyes();
void lrf_expressions_disableExpressiveEyes();
void lrf_expressions_setExpressiveEyeState(LRFExpressiveEyesState state);


#if LRF_SYSTEM_TEST
void lrf_expressions_test(void);
#endif

#ifdef __cplusplus
}
#endif

#endif
