//
//  LRFExpressionData.h
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-05-01.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//	Additional copyright information found at http://littlerobotfriends.com/legal/

#ifndef __LRF_EXPRESSION_DATA_H
#define __LRF_EXPRESSION_DATA_H

#include "../types/lrf_types.h"

#define LRF_DEFAULT_EXPRESSIONS_COUNT			31
#define LRF_CUSTOM_EXPRESSIONS_COUNT			8

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	// Hellos (3)
	LRFExpressionName_Hello = 0,
	LRFExpressionName_HappyHello,
	LRFExpressionName_AngryHello,

	// Moods (8)
	LRFExpressionName_Happy,
	LRFExpressionName_VeryHappy,
	LRFExpressionName_Excited,
	LRFExpressionName_VeryExcited,
	LRFExpressionName_Annoyed,
	LRFExpressionName_VeryAnnoyed,
	LRFExpressionName_Angry,
	LRFExpressionName_VeryAngry,

	// Laughs (4)
	LRFExpressionName_Giggle,
	LRFExpressionName_Laugh,
	LRFExpressionName_Hysterical,
	LRFExpressionName_Cackle,

	// Cries (2)
	LRFExpressionName_Pout,
	LRFExpressionName_Sob,

	// Scared (3)
	LRFExpressionName_Scared,
	LRFExpressionName_Terrified,
	LRFExpressionName_Relieved,

	// Sleepy (3)
	LRFExpressionName_Bored,
	LRFExpressionName_Yawn,
	LRFExpressionName_Snoring,

	// System (3)
	LRFExpressionName_Hungry,
	LRFExpressionName_PowerUp,
	LRFExpressionName_Alarm,

	// New Ones
	LRFExpressionName_Awww,
	LRFExpressionName_Yikes,
	LRFExpressionName_WhoaUp,
	LRFExpressionName_WhoaDown,
	LRFExpressionName_WhoaWhoaWhoa,

	// Special (2 - don't count these)
	LRFExpressionName_Custom		= 0xa0,
	LRFExpressionName_Temp			= 0xfd,
	LRFExpressionName_Signature	= 0xfe,
	LRFExpressionName_Null			= 0xff

} LRFExpressionName;

extern const LRFExpression lrf_default_expressions[LRF_DEFAULT_EXPRESSIONS_COUNT];

#ifdef __cplusplus
}
#endif

#endif
