#ifndef __LRF_CONSTANTS_H
#define __LRF_CONSTANTS_H

#include <stdbool.h>
#include <stdint.h>

#define LRF_FIRMWARE_VERSION_MAJOR       2
#define LRF_FIRMWARE_VERSION_MINOR       3
#define LRF_FIRMWARE_VERSION_PATCH       2

#define LRF_DEVICE_TEST					0
#define LRF_SYSTEM_TEST					0

#ifndef LRF_DEBUG_OUTPUT
#define LRF_DEBUG_OUTPUT  			1  // debug output on
// #define LRF_DEBUG_OUTPUT  			0  // debug output off
#endif

// Delays

#define LRF_DELAY_S(t)		        delay(t*1000)
#define LRF_DELAY_MS(t)	          delay(t)
#define LRF_DELAY_US(t)	          delayMicroseconds(t)
#define LRF_DELAY(t)		          LRF_DELAY_MS(t)
#define LRF_DELAY_TIME						500

// #define LRF_DELAY_START_TIME			1000
#define LRF_DELAY_START_TIME			10



#define LRF_MIC_LOUD_VALUE					   3500

// Senses

#define LRF_MOTION_READ_PERIOD         10		// reading period in ms
#define LRF_MOTION_TAP_TIMING				   5
#define LRF_MOTION_TILT_VALUE				   10

#define LRF_TOUCH_READ_PERIOD				   10		// reading period in ms
#define LRF_TOUCH_TAP_TIMING				   5

#define LRF_HEARING_READ_PERIOD			10

#define LRF_TOUCH_LONG_TIMING           10

#endif
