
#include "LRFEyes.h"

LRFColorValue LRFEyes::getLeft(void)
{
	return lrf_eyes.left;
}

LRFColorValue LRFEyes::getRight(void)
{
	return lrf_eyes.right;
}

void LRFEyes::set(unsigned char red, unsigned char green, unsigned char blue)
{
	lrf_eyes_set(red, green, blue);
}

void LRFEyes::setLeft(unsigned char red, unsigned char green, unsigned char blue)
{
	lrf_eyes_setLeft(red, green, blue);
}

void LRFEyes::setRight(unsigned char red, unsigned char green, unsigned char blue)
{
	lrf_eyes_setRight(red, green, blue);
}

void LRFEyes::setColor(LRFColor color)
{
	lrf_eyes_setColor(color);
}

void LRFEyes::setLeftColor(LRFColor color)
{
	lrf_eyes_setLeftColor(color);
}

void LRFEyes::setRightColor(LRFColor color)
{
	lrf_eyes_setRightColor(color);
}

void LRFEyes::setChannel(LRFLedsChannel channel, unsigned char value)
{
	lrf_leds_set(channel, value);
}

void LRFEyes::clear(void)
{
	lrf_eyes_setColor(LRFColor_Clear);
}

void LRFEyes::blinkColor(LRFColor color, unsigned int duration, bool blocking)
{
	if(blocking)
	{
		lrf_eyes_setColor(color);
		delay(duration);
		lrf_eyes_setColor(LRFColor_Clear);
	}
	else
	{
		lrf_eyes_setColor(color);
		delay(duration);
		lrf_eyes_setColor(LRFColor_Clear);
	}
}

void LRFEyes::blinkPattern(LRFPattern pattern, bool blocking)
{
	if(blocking)
	{
		lrf_eyes_blinkPatternBlocking(pattern);
	}
	else
	{
		lrf_eyes_blinkPattern(pattern);
	}

}

void LRFEyes::blinkPatterns(LRFPattern *patterns, unsigned char count, bool blocking)
{
	if(blocking)
	{
		lrf_eyes_blinkPatternsBlocking(patterns, count);
	}
	else
	{
		lrf_eyes_blinkPatterns(patterns, count);
	}
}

bool LRFEyes::isBlinking(void)
{
	if(lrf_eyes.state == LRFEyesState_Idle)
	{
		return false;
	}
	else
	{
		return true;
	}
}
