
#include <LittleRobotFriends.h>

/*
 * Events happen when your robot auto-magically detects a sequence
 * of things happen - whether it be from its senses (detect touch
 * or detect sound, etc), from its serial ports (received messages or data
 * over IR or USB), or from its own brain (hungry, tired, bored, etc.)
 *
 * Events are 'firing' all the time. If we want to do something special
 * when an event 'fires' we just have to create an EventHandler to catch
 * the signal and perform an action.
 *
 * EventHandlers are custom-made functions that take an event input and
 * do something. Almost anything. But the easiest one is to blinkAndSay
 * an expression!
 *
 */

LRFExpression myExpression =
{
  .pattern = { LRFColor_Green, LRFColor_Purple, LRFTransform_Boomerang, LRFDuration_DoubleLong },
  .sounds = {
    { LRFNote_C, LRFOctave_3, LRFIntonation_Flat, LRFDuration_DoubleLong, LRFDuration_Medium },
    { LRFNote_C, LRFOctave_3, LRFIntonation_Rising, LRFDuration_DoubleLong, LRFDuration_Medium },
    { LRFNote_C, LRFOctave_3, LRFIntonation_Falling, LRFDuration_DoubleLong, LRFDuration_Medium },
    { LRFNote_C, LRFOctave_3, LRFIntonation_Peaking, LRFDuration_DoubleLong, LRFDuration_Medium }
  }
};


// ------------------------------
// Event Handlers
// ------------------------------

void myTapHandler(LRFEvent event)
{
  lrf.blinkAndSay(&myExpression);
}

void myTickleHandler(LRFEvent event)
{
  lrf.blinkAndSayPreset(LRFExpressionName_Excited);
}

// ------------------------------
// Setup & Loop
// ------------------------------

void setup()
{
  // turn things on/off before we set-up
  lrf.motion.disable();
  lrf.hearing.disable();
  //lrf.touch.disable();
  lrf.sight.disable();

  // set up our library
  lrf.setup();

  // set an event handler for when we tap our hair
  lrf.setEventHandler(LRFEvent_Tap, myTapHandler);

  // another event handler for when we tickle our hair
  lrf.setEventHandler(LRFEvent_Tickle, myTickleHandler);
}

void loop()
{
  // service our library loop
  lrf.loop();
}
