
#include <LittleRobotFriends.h>

/*   We can also make our robot perform multiple patterns at once. Or recycle the same pattern
 *   in different ways.
 *
 *   Let's check out all our transforms using an array of patterns.
 */

LRFPattern myPatterns[6] =
{
  { LRFColor_Red, LRFColor_Blue, LRFTransform_None, LRFDuration_DoubleLong },       // just fade
  { LRFColor_Red, LRFColor_Blue, LRFTransform_Boomerang, LRFDuration_DoubleLong },  // fade from A to B then back to A
  { LRFColor_Red, LRFColor_Blue, LRFTransform_ZigZag, LRFDuration_DoubleLong },     // left eye is A, right eye is B, cross-fade
  { LRFColor_Red, LRFColor_Blue, LRFTransform_Flat, LRFDuration_DoubleLong },       // no fading
  { LRFColor_Red, LRFColor_Blue, LRFTransform_Flip, LRFDuration_DoubleLong },       // after the pattern runs, flip values
  { LRFColor_Red, LRFColor_Blue, LRFTransform_Random, LRFDuration_DoubleLong },     // pick random transforms
};

// transforms can also be combined!
LRFPattern myCombinedPattern = {
  .colorA = LRFColor_Green,
  .colorB = LRFColor_Purple,
  .transform = (LRFTransform)(LRFTransform_Boomerang | LRFTransform_ZigZag | LRFTransform_Flip),
  .duration = LRFDuration_DoubleLong
};

// ------------------------------
// Setup & Loop
// ------------------------------

void setup()
{
  // disable our sensors so they don't interfere with our patterns
  lrf.motion.disable();
  lrf.hearing.disable();
  lrf.touch.disable();
  lrf.sight.disable();

  // set up our library
  lrf.setup();
}

void loop()
{
  // run our library loop
  lrf.loop();

  // blink our patterns (blocking function)
  lrf.eyes.blinkPatterns(myPatterns, 6, 1000, true);

  // blink our combined pattern
  lrf.eyes.blinkPattern(myCombinedPattern, true);

  // short delay
  delay(1000);
}
