
#ifndef __LRF_SOUND_H
#define __LRF_SOUND_H

#include <stdint.h>
#include <math.h>
#include "lrf_duration.h"

#ifdef __cplusplus
extern "C" {
#endif

#define LRF_SOUND_BLANK		{ LRFNote_NULL }
#define LRF_SOUND_SIZE			2


typedef enum
{
	LRFNote_A = 0,	//!< A	(55 hertz at octave #1)
	LRFNote_AS,			//!< A#	(58hz)
	LRFNote_B,			//!< B	(62hz)
	LRFNote_C,			//!< C	(65hz)
	LRFNote_CS,			//!< C#	(69hz)
	LRFNote_D,			//!< D	(73hz)
	LRFNote_DS,			//!< D#	(78hz)
	LRFNote_E,			//!< E	(82hz)
	LRFNote_F,			//!< F	(87hz)
	LRFNote_FS,			//!< F#	(92hz)
	LRFNote_G,			//!< G	(98hz)
	LRFNote_GS,			//!< G#	(104hz)
	LRFNote_Mute,		//!< G#	(104hz)
	LRFNote_NULL = 15	//!< Catching undefined notes
} LRFNote;

typedef enum
{
	LRFOctave_1 = 0,	//!< lowest possible octave (some notes are unplayable)
	LRFOctave_2,		//!< lower octave
	LRFOctave_3,		//!< middle-low octave
	LRFOctave_4,		//!< middle octave
	LRFOctave_5,		//!< middle-high octave
	LRFOctave_6,		//!< high octave
	LRFOctave_7,		//!< higher octave
	LRFOctave_8			//!< highest possible octave
} LRFOctave;

typedef enum
{
	LRFIntonation_Flat = 0,		//!< Flat tone (no change)
	LRFIntonation_Rising = 1,	//!< Rising tone (happy or excited)
	LRFIntonation_Falling = 2,	//!< Falling tone (sad or upset)
	LRFIntonation_Peaking = 3,	//!< Peaking tone (tone rises, then returns to normal)
	LRFIntonation_Dipping = 4	//!< Dipping tone (tone dips, then returns to normal)
} LRFIntonation;

typedef enum
{
	LRFBeat_0 = LRFDuration_None,
	LRFBeat_1 = LRFDuration_Short,
	LRFBeat_2 = LRFDuration_DoubleShort,
	LRFBeat_4 = LRFDuration_Medium,
	LRFBeat_8 = LRFDuration_DoubleMedium,
	LRFBeat_16 = LRFDuration_Long,
	LRFBeat_32 = LRFDuration_DoubleLong,
	LRFBeat_64 = LRFDuration_VeryLong,
} LRFBeat;

typedef struct __attribute__((__packed__))
{
	LRFNote				note:4;				//!< musical note (base frequency)
	LRFOctave			octave:3;			//!< musical octave (scale the frequency)
	LRFIntonation	intonation:3;	//!< bend applied to the frequency (over duration_
	LRFDuration		duration:3;		//!< time the note is played
	LRFDuration		pause:3;			//!< time that we rest after the note is played
} LRFSound;

typedef union
{
	LRFSound		sound;
	uint8_t			bytes[LRF_SOUND_SIZE];
	uint16_t		word;
} LRFSoundUnion;


unsigned int lrf_sound_noteToFrequency(LRFNote note, LRFOctave octave);



#ifdef __cplusplus
}
#endif

#endif
