
#ifndef __LRF_HEARING_H
#define __LRF_HEARING_H

#include "../../lrf_constants.h"
#include "../types/lrf_sensor.h"

#ifdef __cplusplus
extern "C" {
#endif

// the states of our sensor
typedef enum
{
	LRFHearingState_Idle = 0,
	LRFHearingState_Normal,
	LRFHearingState_Talking,
	LRFHearingState_TooLoud,
} LRFHearingState;

// define our library object
typedef struct
{
	bool			enabled;
	bool			debug;
	uint32_t		nextReadTime;

	bool			talkingFlag;
	uint32_t		talkingTimestamp;
	uint8_t			talkingCount;
	uint16_t		talkingLevel;

	bool			tooLoudFlag;
	uint32_t		tooLoudTimestamp;
	uint8_t			tooLoudCount;
	uint16_t		tooLoudLevel;

	LRFSensor		level;
} LRFHearing_t;

// Library object
extern LRFHearing_t lrf_hearing;

// Public functions
void lrf_hearing_init(void);
void lrf_hearing_update(void);

void lrf_hearing_debug(void);

// Test
#if LRF_SYSTEM_TEST
void lrf_hearing_test(void);
#endif

#ifdef __cplusplus
}
#endif

#endif
