#ifndef __LRF_SPEECH_H
#define __LRF_SPEECH_H

#include "types/lrf_types.h"
#include "../lrf_constants.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
  LRFSpeechState_Idle = 0,
  LRFSpeechState_Ready,
  LRFSpeechState_Speaking,
  LRFSpeechState_Pausing,
  LRFSpeechState_Done = 255
} LRFSpeechState;

typedef struct
{
  LRFSpeechState  state;

  unsigned int    freq;
  LRFSound        sound;
  LRFSound        queue[16];
  unsigned int    queueIdx;
  unsigned int    queueCount;
  LRFFunctionPtr  queueDoneCallback;
  unsigned long   startTime;
  unsigned int    duration;
  bool            silence;
} LRFSpeech_t;

extern LRFSpeech_t lrf_speech;

void lrf_speech_init(void);
void lrf_speech_run(void);

void lrf_speech_reset(void);

void lrf_speech_silence(bool bSilent);

void lrf_speech_tone(unsigned int freq);
void lrf_speech_noTone(void);

void lrf_speech_saySound(LRFSound sound, LRFFunctionPtr callback = NULL);
void lrf_speech_saySoundBlocking(LRFSound sound);

void lrf_speech_saySounds(LRFSound *sounds, unsigned int count, LRFFunctionPtr callback = NULL);
void lrf_speech_saySoundsBlocking(LRFSound *sound, unsigned int count);

#if LRF_SYSTEM_TEST
void lrf_speech_test(void);
#endif

#ifdef __cplusplus
}
#endif

#endif
