#ifndef __LRF_EYES_H
#define __LRF_EYES_H

#include "types/lrf_types.h"
#include "../lrf_constants.h"

#ifdef __cplusplus
extern "C" {
#endif

#define LRF_EYES_DEBUG_VERBOSE			false

typedef enum
{
	LRFEyesState_Idle = 0,
	LRFEyesState_Ready,
	LRFEyesState_Running,
	LRFEyesState_Toggling,
	LRFEyesState_Done = 255
} LRFEyesState;

typedef struct
{
	bool						enabled;
	LRFEyesState		state;

	// current values for left & right eyes
	LRFColorValue		left;
	LRFColorValue		right;

	// storage for current pattern
	LRFPattern			pattern;
	LRFColorValue		sLeft;
	LRFColorValue		tLeft;
	LRFColorValue		sRight;
	LRFColorValue		tRight;

	// queue
	LRFPattern			queue[16];
	unsigned char 	queueIdx;
	unsigned char		queueCount;
	LRFFunctionPtr	queueDoneCallback;

	// start time and duration of pattern
	unsigned long		startTime;
	unsigned int		duration;

} LRFEyes_t;

extern LRFEyes_t lrf_eyes;

void lrf_eyes_init(void);
void lrf_eyes_run(void);

void lrf_eyes_reset(bool clear=true);

void lrf_eyes_setRight(uint8_t red, uint8_t green, uint8_t blue);
void lrf_eyes_setLeft(uint8_t red, uint8_t green, uint8_t blue);
void lrf_eyes_set(uint8_t red, uint8_t green, uint8_t blue);

void lrf_eyes_setColor(LRFColor color);									// set both eyes to a single color
void lrf_eyes_setColors(LRFColor leftColor, LRFColor rightColor);			// set a color for each eye
void lrf_eyes_setLeftColor(LRFColor color);
void lrf_eyes_setRightColor(LRFColor color);

void lrf_eyes_lookupColor(LRFColor color, LRFColorValue *value);
void lrf_eyes_lookupRandom(LRFColorValue *value);

// playing patterns
void lrf_eyes_blinkPattern(LRFPattern pattern, LRFFunctionPtr callback=NULL);	// play a pattern on the eyes
void lrf_eyes_blinkPatternBlocking(LRFPattern pattern);						// play a pattern and block the thread until complete
void lrf_eyes_blinkPatternBlockingAdvanced(LRFPattern pattern, uint8_t times, uint16_t pause);

void lrf_eyes_blinkPatterns(LRFPattern *patterns, uint8_t count, LRFFunctionPtr callback=NULL);
void lrf_eyes_blinkPatternsBlocking(LRFPattern *patterns, uint8_t count);

void lrf_eyes_resetPattern(void);

// write the current values onto the LEDs
void lrf_eyes_update(void);

#if LRF_SYSTEM_TEST
void lrf_eyes_test(void);
#endif


#ifdef __cplusplus
}
#endif

#endif
