/*
	lrf_device_pins - definitions for the currently targeted hardware device

	- in this case, we're talking about our Arduino Zero/M0 derivitive project, based on the Atmel SAMD21G18A

	LRF_NAME	ARDUINO		SAMD21		Description
	-------------------------------------------------------------
	IR_RX				D0			PA11			Infrared Receiver
	IR_TX				D1			PA10			Infrared Transmitter (LED)
							D2			PA14
	BATT_SENSE	D3			PA09			(AIN18) Reading the battery level
	RGBL_R			D4			PA08			TCC0/WO0
	RGBL_G			D5			PA15			TCC0/WO5
	RGBL_B			D6			PA20			TCC0/WO6
	RGBR_R			D7			PA21			TCC0/WO7
	RGBR_G			D8			PA06			TCC1/WO0
	RGBR_B			D9			PA07			TCC1/WO1
	TCH2				D10			PA18      HW2.1-ONLY Backup TouchKey
	SPKR				D11			PA16			Speaker
	TCH3			  D12			PA19      HW2.1-ONLY Backup TouchKey
	TCH1				D13			PA17      HW2.1-ONLY Backup TouchKey
							GND			GND
	3V3					AREF		PA03
	SDA					SDA			PA22			i2c data for face
	SCL					SCL			PA23			i2c clock for face

	SPKR_DAC		A0			PA02			DAC output for speaker
	MIC					A1			PB08			Microphone input
	LIGHT				A2			PB09			Photocell input
	TOUCH_INT		A3			PA04			Touch Interrupt
	GP					A4			PA05			Reserved for magical purposes
	TX					A5			PB02			Serial output

	RX									PB03			Serial input
	SDA2								PA12			i2c data for accelerometer & touch sensor
	SCL2								PA11			i2c clock for accelerometer & touch sensor
	USB-								PA24			USB-
	USB+								PA25			USB+
	EXP2								PA27			Expansion 2
	EXP3								PA28			Expansion 3
	SWCLK								PA30
	SWDIO								PA31
	STATUS_LED					PB22			Blue status LED
	EXP1								PB23			Expansion 1 

*/


/*

	LRF Timer Usage

	TC0

	TCC0, 4-channel, 8-output, 24-bit
	TCC1, 2-channel, 4-output, 24-bit
	TCC2, 2-channel, 2-output, 16-bit

	We want to use TCC0.WO2, the 24-bit counter running at ???

	Is there an LED using it?

	WO2 == WO6, which is used by D6 (or LB)

	Currently, the LEDs are using:

	TCC0.WO0
	TCC0.WO4
	TCC0.WO1
	TCC0.WO5
	TCC0.WO2
	TCC0.WO6
	TCC0.WO3
	TCC0.WO7

	TCC1.WO0
	TCC1.WO4
	TCC1.WO1
	TCC1.WO5
	TCC1.WO2
	TCC1.WO6
	TCC1.WO3
	TCC1.WO7

 */

#ifndef __LRF_DEVICE_PINS_H
#define __LRF_DEVICE_PINS_H

// These definitions map to entries in variant.cpp

#define LRF_PINS_RGBL_R					4		// D4
#define LRF_PINS_RGBL_G					5		// D5
#define LRF_PINS_RGBL_B					6		// D6
#define LRF_PINS_RGBR_R					7		// D7
#define LRF_PINS_RGBR_G					8		// D8
#define LRF_PINS_RGBR_B					9		// D9

#define LRF_PINS_STATUS_LED     30  // PB22
#define LRF_PINS_GP             18  // A4 / PA05

#define LRF_PINS_SDA						20
#define LRF_PINS_SCL						21

#define LRF_PINS_MIC						15		// A1
#define LRF_PINS_LIGHT					16		// A2
#define LRF_PINS_BATT_SENSE			3			// D3



#endif
