
#ifndef __LRF_CAPSENSE_H
#define __LRF_CAPSENSE_H

#include "../lrf_constants.h"
#include "../lrf_debug.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	LRFCapSenseChannel_Hair = 2,
	LRFCapSenseChannel_Left = 4,
	LRFCapSenseChannel_Right = 1
} LRFCapSenseChannel;

typedef struct __attribute__((__packed__))
{
	LRFDebugLevel		debugLevel;
	uint8_t					device;
	uint8_t					hair;
	uint8_t					left;
	uint8_t					right;
	bool						dpsRemap;
} LRFCapSense_t;

extern LRFCapSense_t lrf_capSense;

void lrf_capSense_init(void);
void lrf_capSense_read(void);
void lrf_capSense_setChannelThreshold(LRFCapSenseChannel channel, uint8_t threshold);

#if LRF_DEVICE_TEST
void lrf_capSense_test(void);
#endif

#ifdef __cplusplus
}
#endif

#endif
