
#ifndef __LRF_ACCEL_H
#define __LRF_ACCEL_H

#include "../lrf_constants.h"
#include "../lrf_debug.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	LRFAccelOrientation_Unknown = 0,
	LRFAccelOrientation_Up		= 1,
	LRFAccelOrientation_Down	= 2,
	LRFAccelOrientation_Right	= 3,
	LRFAccelOrientation_Left	= 4,
	LRFAccelOrientation_Front	= 5,
	LRFAccelOrientation_Back	= 6
} LRFAccelOrientation;

typedef struct
{
	LRFDebugLevel debugLevel;
	uint8_t device;
	int8_t x;
	int8_t y;
	int8_t z;
	LRFAccelOrientation orientation;
	bool shake;
	bool bump;
} LRFAccel_t;

extern LRFAccel_t lrf_accel;

void lrf_accel_init(void);
void lrf_accel_read(void);
void lrf_accel_test(void);

#ifdef __cplusplus
}
#endif

#endif /* LRF_ACCEL_H_ */
