#include "LRFSpeech.h"

unsigned int LRFSpeech::getFrequency(void)
{
    return lrf_speaker_get_frequency();
}

void LRFSpeech::setFrequency(unsigned int freq)
{
  lrf_speech_tone(freq);
}

void LRFSpeech::quiet(void)
{
  lrf_speech_noTone();
}

void LRFSpeech::saySound(LRFSound sound, bool blocking)
{
  if(blocking)
  {
    lrf_speech_saySoundBlocking(sound);
  }
  else
  {
    lrf_speech_saySound(sound);
  }
}

void LRFSpeech::saySounds(LRFSound *sounds, unsigned char count, bool blocking)
{
  if(blocking)
  {
    lrf_speech_saySoundsBlocking(sounds, count);
  }
  else
  {
    lrf_speech_saySounds(sounds, count);
  }
}

bool LRFSpeech::isSpeaking(void)
{
	if(lrf_speech.state == LRFSpeechState_Idle)
	{
		return false;
	}
	else
	{
		return true;
	}
}
