#ifndef __LRFEYES_H
#define __LRFEYES_H

#include "LRFConfig.h"

class LRFEyes
{
public:
	LRFColorValue getLeft();
	LRFColorValue getRight();

	void set(unsigned char red, unsigned char green, unsigned char blue);
	void setLeft(unsigned char red, unsigned char green, unsigned char blue);
	void setRight(unsigned char red, unsigned char green, unsigned char blue);

	void setColor(LRFColor color);
	void setLeftColor(LRFColor color);
	void setRightColor(LRFColor color);
	void setChannel(LRFLedsChannel channel, unsigned char value);

	void clear();

	void blinkColor(LRFColor color, unsigned int duration=500, bool blocking=false);
	void blinkPattern(LRFPattern pattern, bool blocking=false);
	void blinkPatterns(LRFPattern *patterns, unsigned char count, bool blocking=false);
	bool isBlinking(void);

private:
	// nothing right now
};

#endif
