
#include "LRFInfrared.h"

void LRFInfrared::enable(void)
{
  // enable listening to IR in the core library
  lrf_infrared.enabled = true;
}

void LRFInfrared::disable(void)
{
  // disable listening to IR in the core library
  lrf_infrared.enabled = false;
}

// writing
void LRFInfrared::writeMessage(LRFMessage *msg)
{
  // pass message to the core library
  lrf_infrared_writeMessage(msg);
}

void LRFInfrared::writeBytes(unsigned char *bytes, unsigned char length)
{
  // send bytes out IR serial port
  SerialIR.write(bytes, length);
}

void LRFInfrared::writeByte(unsigned char byte)
{
  SerialIR.write(byte);
}


// reading
bool LRFInfrared::readMessage(LRFMessage *msg, unsigned int timeout)
{
  uint32_t t = millis() + 1000;
  // keep checking our serial port until we have a message
  while(millis() < t)
  {
    if(lrf_message_read_uart(&SerialIR, msg))
    {
      // looks like we got a message :-)
      return true;
    }
  }
  // looks like we timed out :-(
  return false;
}

unsigned char LRFInfrared::readBytes(unsigned char *bytes, unsigned char length, unsigned int timeout)
{
  uint32_t t = millis() + 1000;
  uint8_t n = 0;
  // keep checking our serial port until we have a message
  while(millis() < t)
  {
    while(SerialIR.available())
    {
      bytes[n] = SerialIR.read();
      n++;
      if(n == length) return n; // we filled our quota.. return n
    }
  }
  // looks like we timed out, or have partial data :-(
  return n;
}

bool LRFInfrared::readByte(unsigned char *byte, unsigned int timeout)
{
  uint32_t t = millis() + 1000;
  // keep checking our serial port until we have a message
  while(millis() < t)
  {
    if(SerialIR.available())
    {
      *byte = SerialIR.read();
      return true;
    }
  }
  // looks like we timed out :-(
  return false;
}


// using message handlers
void LRFInfrared::setMessageHandler(LRFMessageHandler handler)
{
  lrf_infrared_setMessageHandler(handler);
}
