
#include <LittleRobotFriends.h>

/*
 * Senses are all the ways your robot experiences the physical world. Its
 * touch sensor detects when your touch the hands or hair. Its microphone and light
 * sensor gives your robot hearing (loud or quiet) and sight (bright or dark).
 * The motion sensor detects tilts and shakes.
 *
 * All of these senses are automatically being read in the library loop (lrf.loop())
 * and if they match certain conditions they create events.
 *
 * But - if you want to read these senses yourself there is a way to do that!
 *
 * Important to remember - you must still perform the library loop to
 * properly read the sensors.
 *
 */

// ------------------------------
// Setup & Loop
// ------------------------------

void setup()
{
  // set up our library
  lrf.setup();

  // disable ALL events from being fired
  lrf.disableEvents();
}

void loop()
{
  // service our library loop
  lrf.loop();

  // when our hair is being touched, blinkAndSay an expression!
  if(lrf.touch.readHair() == 1)
  {
    lrf.blinkAndSayPreset(LRFExpressionName_Hello);
  }

  // when our robot tilts left or right, blinkAndSay expressions!
  if(lrf.motion.readX() > 10)
  {
    lrf.blinkAndSayPreset(LRFExpressionName_Giggle);
  }
  else if(lrf.motion.readX() < -10)
  {
    lrf.blinkAndSayPreset(LRFExpressionName_Angry);
  }
}
