
#include <LittleRobotFriends.h>

/*
 * Expressions are the main way your robot will communicate.
 *
 * Each expression is a combination of 1 pattern and 4 sounds.
 *
 * Why 1 pattern? Why 4 sounds? It's the perfect size to capture
 * a single thought or feeling for a robot. Want more complex
 * reactions? Just combine expressions!
 *
 * There are two ways to use expressions:
 * 1) by making custom ones in code
 * 2) by using built-in presets
 *
 * We 'blinkAndSay' expressions by using a pointer. A pointer
 * passes a reference to a variable, rather than the variable itself.
 *
 * Think of it like telling your brother or sister where to find
 * the box of cereal, rather than going and getting the box for them.
 *
 * Pointers are passed with the '&' symbol, and looked up with the '*' symbol
 */

LRFExpression myExpression =
{
  .pattern = { LRFColor_Green, LRFColor_Purple, LRFTransform_Boomerang, LRFDuration_DoubleLong },
  .sounds = {
    { LRFNote_C, LRFOctave_3, LRFIntonation_Flat, LRFDuration_DoubleLong, LRFDuration_Medium },
    { LRFNote_C, LRFOctave_3, LRFIntonation_Rising, LRFDuration_DoubleLong, LRFDuration_Medium },
    { LRFNote_C, LRFOctave_3, LRFIntonation_Falling, LRFDuration_DoubleLong, LRFDuration_Medium },
    { LRFNote_C, LRFOctave_3, LRFIntonation_Peaking, LRFDuration_DoubleLong, LRFDuration_Medium }
  }
};


// ------------------------------
// Setup & Loop
// ------------------------------

void setup()
{
  // turn things on/off before we set-up
  lrf.motion.disable();
  lrf.hearing.disable();
  lrf.touch.disable();
  lrf.sight.disable();

  // set up our library
  lrf.setup();
}

void loop()
{
  // service our library loop
  lrf.loop();

  // pass a pointer to our expression
  lrf.blinkAndSay(&myExpression);
  delay(1000);

  // blinkAndSay a preset expression
  lrf.blinkAndSayPreset(LRFExpressionName_Hello);
  delay(1000);
}
