
#include <LittleRobotFriends.h>

// using PATTERNS is a way to control the led eyes using simple animations called transforms
// they have two colors - A and B - and depending on the transform, it will change the way
// the colors animate

// two ways to make a pattern

// 1) longform
LRFPattern myPattern = {
  .colorA = LRFColor_Red,
  .colorB = LRFColor_Blue,
  .transform = LRFTransform_ZigZag,
  .duration = LRFDuration_Long
};

// 2) shortform
LRFPattern myOtherPattern = { LRFColor_Green, LRFColor_Purple, LRFTransform_Boomerang, LRFDuration_DoubleLong };

bool patternToggle = false;

// ------------------------------
// Setup & Loop
// ------------------------------

void setup()
{
  // set up our library
  lrf.setup();
}

void loop()
{
  // run our library loop
  lrf.loop();

  // blink our pattern
  if(patternToggle)
  {
    lrf.eyes.blinkPattern(myPattern, true); // blink & block
  }
  else
  {
    lrf.eyes.blinkPattern(myOtherPattern, true); // blink & block
  }

  // flip the value
  patternToggle = !patternToggle;

  // delay
  delay(1000);

}
