
#ifndef _VARIANT_LRF_
#define _VARIANT_LRF_

// The definitions here needs a SAMD core >=1.6.3
#define ARDUINO_SAMD_VARIANT_COMPLIANCE 10603

/*----------------------------------------------------------------------------
 *        Definitions
 *----------------------------------------------------------------------------*/

/** Frequency of the board main oscillator */
#define VARIANT_MAINOSC		(32768ul)

/** Master clock frequency */
#define VARIANT_MCK			  (48000000ul)

/*----------------------------------------------------------------------------
 *        Headers
 *----------------------------------------------------------------------------*/

#include "WVariant.h"


#ifdef __cplusplus
//#include "/.h"
#include "SERCOM.h"
#include "Uart.h"
#endif // __cplusplus

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

/*----------------------------------------------------------------------------
 *        Pins
 *----------------------------------------------------------------------------*/

// Number of pins defined in PinDescription array
#define PINS_COUNT           (26u)
#define NUM_DIGITAL_PINS     (14u)
#define NUM_ANALOG_INPUTS    (6u)
#define NUM_ANALOG_OUTPUTS   (1u)

#define digitalPinToPort(P)        ( &(PORT->Group[g_APinDescription[P].ulPort]) )
#define digitalPinToBitMask(P)     ( 1 << g_APinDescription[P].ulPin )
//#define analogInPinToBit(P)        ( )
#define portOutputRegister(port)   ( &(port->OUT.reg) )
#define portInputRegister(port)    ( &(port->IN.reg) )
#define portModeRegister(port)     ( &(port->DIR.reg) )
#define digitalPinHasPWM(P)        ( g_APinDescription[P].ulPWMChannel != NOT_ON_PWM || g_APinDescription[P].ulTCChannel != NOT_ON_TIMER )

/*
 * digitalPinToTimer(..) is AVR-specific and is not defined for SAMD
 * architecture. If you need to check if a pin supports PWM you must
 * use digitalPinHasPWM(..).
 *
 * https://github.com/arduino/Arduino/issues/1833
 */
// #define digitalPinToTimer(P)

// Interrupts
#define digitalPinToInterrupt(P)   ( g_APinDescription[P].ulExtInt )

// LEDs
// #define PIN_LED_13           (13u)
// #define PIN_LED_RXL          (25u)
// #define PIN_LED_TXL          (26u)
// #define PIN_LED              PIN_LED_13
// #define PIN_LED2             PIN_LED_RXL
// #define PIN_LED3             PIN_LED_TXL
// #define LED_BUILTIN          PIN_LED_13

/*
 * Analog pins
 */
#define PIN_A0               (14ul)
#define PIN_A1               (15ul)
#define PIN_A2               (16ul)
#define PIN_A3               (17ul)
#define PIN_A4               (18ul)
#define PIN_A5               (19ul)
#define PIN_DAC0             (14ul)

static const uint8_t A0  = PIN_A0;
static const uint8_t A1  = PIN_A1;
static const uint8_t A2  = PIN_A2;
static const uint8_t A3  = PIN_A3;
static const uint8_t A4  = PIN_A4;
static const uint8_t A5  = PIN_A5;
static const uint8_t DAC0 = PIN_DAC0;
#define ADC_RESOLUTION		12

// Other pins
#define PIN_ATN              (38ul)
static const uint8_t ATN = PIN_ATN;

/*
 * Serial interfaces
 */
// Serial (EDBG)
//#define PIN_SERIAL_RX       (31ul)
//#define PIN_SERIAL_TX       (30ul)
//#define PAD_SERIAL_TX       (UART_TX_PAD_2)
//#define PAD_SERIAL_RX       (SERCOM_RX_PAD_3)

// SerialExt Pins & Pads (SERCOM5)
#define PIN_SERIAL_EXT_RX      (25ul)
#define PIN_SERIAL_EXT_TX      (19ul)
#define PAD_SERIAL_EXT_TX      (UART_TX_PAD_0)
#define PAD_SERIAL_EXT_RX      (SERCOM_RX_PAD_1)

// SerialIR Pins & Pads (SERCOM0)
#define PIN_SERIAL_IR_RX        (0ul)
#define PIN_SERIAL_IR_TX        (1ul)
#define PAD_SERIAL_IR_TX        (UART_TX_PAD_2)
#define PAD_SERIAL_IR_RX        (SERCOM_RX_PAD_3)


/*
 * SPI Interfaces
 */
#define SPI_INTERFACES_COUNT 0

//#define PIN_SPI_MISO         (22u)
//#define PIN_SPI_MOSI         (23u)
//#define PIN_SPI_SCK          (24u)
//#define PERIPH_SPI           sercom4
//#define PAD_SPI_TX           SPI_PAD_2_SCK_3
//#define PAD_SPI_RX           SERCOM_RX_PAD_0
//
//static const uint8_t SS	  = PIN_A2 ;	// SERCOM4 last PAD is present on A2 but HW SS isn't used. Set here only for reference.
//static const uint8_t MOSI = PIN_SPI_MOSI ;
//static const uint8_t MISO = PIN_SPI_MISO ;
//static const uint8_t SCK  = PIN_SPI_SCK ;

/*
 * Wire Interfaces
 */
#define WIRE_INTERFACES_COUNT 2

// SDA/SCL for Body
#define PIN_WIRE_SDA         (20u)
#define PIN_WIRE_SCL         (21u)
#define PERIPH_WIRE          sercom3
#define WIRE_IT_HANDLER      SERCOM3_Handler

// SDA/SCL for Accel/Touch
#define PIN_WIRE1_SDA        (22u)
#define PIN_WIRE1_SCL        (38u)
#define PERIPH_WIRE1         sercom2
#define WIRE1_IT_HANDLER     SERCOM2_Handler

/*
 * USB
 */
#define PIN_USB_HOST_ENABLE (27ul)
#define PIN_USB_DM          (28ul)
#define PIN_USB_DP          (29ul)


#define PIN_CHARGE_SENSE	(30ul)		// PB22

#ifdef __cplusplus
}
#endif

/*----------------------------------------------------------------------------
 *        Arduino objects - C++ only
 *----------------------------------------------------------------------------*/

#ifdef __cplusplus

/*	=========================
 *	===== SERCOM DEFINITION
 *	=========================
*/
extern SERCOM sercom0;
extern SERCOM sercom1;
extern SERCOM sercom2;
extern SERCOM sercom3;
extern SERCOM sercom4;
extern SERCOM sercom5;

extern Uart SerialExt;
extern Uart SerialIR;
// extern Uart Serial;
// extern Uart Serial1;

#endif

// These serial port names are intended to allow libraries and architecture-neutral
// sketches to automatically default to the correct port name for a particular type
// of use.  For example, a GPS module would normally connect to SERIAL_PORT_HARDWARE_OPEN,
// the first hardware serial port whose RX/TX pins are not dedicated to another use.
//
// SERIAL_PORT_MONITOR        Port which normally prints to the Arduino Serial Monitor
//
// SERIAL_PORT_USBVIRTUAL     Port which is USB virtual serial
//
// SERIAL_PORT_LINUXBRIDGE    Port which connects to a Linux system via Bridge library
//
// SERIAL_PORT_HARDWARE       Hardware serial port, physical RX & TX pins.
//
// SERIAL_PORT_HARDWARE_OPEN  Hardware serial ports which are open for use.  Their RX & TX
//                            pins are NOT connected to anything by default.
#define SERIAL_PORT_USBVIRTUAL      SerialUSB
#define SERIAL_PORT_MONITOR         SerialUSB
// Serial has no physical pins broken out, so it's not listed as HARDWARE port
#define SERIAL_PORT_HARDWARE        SerialExt
#define SERIAL_PORT_HARDWARE_OPEN   SerialExt

#endif /* _VARIANT_LRF_ */
