
#ifndef __LRF_EXPRESSION_H
#define __LRF_EXPRESSION_H

#include <stdint.h>
#include "lrf_pattern.h"
#include "lrf_sound.h"

#define LRF_EXPRESSION_SOUND_COUNT			4
#define LRF_EXPRESSION_SIZE				LRF_PATTERN_SIZE + (LRF_SOUND_SIZE * LRF_EXPRESSION_SOUND_COUNT)
#define LRF_EXPRESSION_INT_SIZE			LRF_EXPRESSION_SIZE / 2

#define LRF_EXPRESSION_BLANK				{ .pattern=LRF_PATTERN_BLANK, .sounds={LRF_SOUND_BLANK} }

#ifdef __cplusplus
extern "C" {
#endif

typedef struct __attribute__((__packed__))
{
	LRFPattern		pattern;
	LRFSound		sounds[LRF_EXPRESSION_SOUND_COUNT];
} LRFExpression;

typedef union
{
	LRFExpression	expression;
	uint8_t			bytes[LRF_EXPRESSION_SIZE];
	uint16_t		words[LRF_EXPRESSION_INT_SIZE];
} LRFExpressionUnion;


#ifdef __cplusplus
}
#endif

#endif
