
#ifndef __LRF_SENSES_H
#define __LRF_SENSES_H

#include "../../lrf_constants.h"
#include "lrf_touch.h"
#include "lrf_motion.h"
#include "lrf_hearing.h"
#include "lrf_sight.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
	bool enabled;
} LRFSenses_t;

extern LRFSenses_t lrf_senses;

void lrf_senses_init(void);
void lrf_senses_update(void);
void lrf_senses_enable(void);
void lrf_senses_disable(void);
void lrf_senses_calibrate(void);

#if LRF_SYSTEM_TEST
void lrf_senses_test(void);
#endif

#ifdef __cplusplus
}
#endif


#endif
