#ifndef __LRF_FACE_H
#define __LRF_FACE_H

#include "../lrf_constants.h"
#include "../lrf_debug.h"

#ifdef __cplusplus
extern "C" {
#endif

#define LRF_FACE_PROTECTED_ADDRESS			0
#define LRF_FACE_PROTECTED_LENGTH				12
#define LRF_FACE_UNPROTECTED_ADDRESS		0x1FF0
#define LRF_FACE_UNPROTECTED_LENGTH			12
#define LRF_FACE_SERIAL_LENGTH					10


#define LRF_FACE_CHECK_LOCK							false
#define LRF_FACE_PROGRAM_WHEN_UNLOCKED	false
#define LRF_FACE_PROGRAM_AND_LOCK				false
#define LRF_FACE_PRINT_PROTECTED_DATA		false

typedef enum
{
	LRFFaceType_Unknown		= 0,
	LRFFaceType_Spikey		= 1,
	LRFFaceType_Curvy			= 2,
	LRFFaceType_Ghosty		= 3,
	LRFFaceType_Crafty		= 4,
	LRFFaceType_Cubby			= 5,
} LRFFaceType;

#define LRF_FACE_TYPE_UNCONFIGURED			0xFF
#define LRF_FACE_TYPE_DEFAULT						LRFFaceType_Cubby
#define LRF_FACE_VERSION_UNCONFIGURED		0xFF
#define LRF_FACE_VERSION_CONFIGURED			0x10

typedef struct __attribute__((__packed__))
{
	LRFDebugLevel debugLevel;
	bool				isConnected;		// is there a face connected?
	bool				isNew;					// has this face been written to before?
	bool 				isLockable;			// does this device use a lockable area?
	bool 				isLocked;				// is the memory locked?
	uint8_t			pageSize;
	uint16_t		memSize;						// what is the device size?
	LRFFaceType	type;						// which face is connected?
	uint8_t			version;				// which version of face type?
	uint8_t			serial[LRF_FACE_SERIAL_LENGTH]; // serial number
} LRFFace_t;

extern LRFFace_t lrf_face;


void lrf_face_init(void);
bool lrf_face_check(void);

// read from main memory
uint16_t lrf_face_read(uint16_t address, uint8_t *data, uint16_t length);
uint16_t lrf_face_readInfo();

// write to main memory
uint16_t lrf_face_write(uint16_t address, uint8_t *data, uint16_t length);
uint16_t lrf_face_writeInfo(bool lock=false);
uint16_t lrf_face_writeDefaultInfo(bool lock=false);

// debugging
void lrf_face_printInfo();

// depricated
// uint16_t lrf_face_program_defaults(bool lock);
// uint16_t lrf_face_program_and_lock(LRFFaceType type, uint8_t version, uint8_t *serial);

#ifdef __cplusplus
}
#endif

#endif
