#ifndef __LITTLEROBOTFRIENDS_H
#define __LITTLEROBOTFRIENDS_H

#include "LRFConfig.h"
#include "outputs/LRFEyes.h"
#include "outputs/LRFSpeech.h"
#include "inputs/LRFTouch.h"
#include "inputs/LRFHearing.h"
#include "inputs/LRFMotion.h"
#include "inputs/LRFSight.h"
#include "communication/LRFInfrared.h"

// our main API class
class LittleRobotFriends
{
public:
	LRFInfrared				infrared;
	LRFTouch					touch;
	LRFHearing				hearing;
	LRFMotion					motion;
	LRFSight					sight;
	LRFEyes						eyes;
	LRFSpeech					speech;


	LittleRobotFriends(void);

	// Robot-Level
	void setup(void);
	void loop(void);

	// Future implementation
	// void wake(void);
	// void sleep(void);
	// void reset(void);

	// Boredom
	void setBoredomTimer(unsigned int seconds);

	// Character
	void getName(String *name);
	void setName(String name);		// make a pointer?

	// Expressions
	void blinkAndSay(LRFExpression *expression, bool blocking = false);
	void blinkAndSayPreset(LRFExpressionName name, bool blocking = false);
	void setExpressionPreset(LRFExpressionName name, LRFExpression *expression);
	bool isExpressing(void);

	// Chat
	void chat(void);
	void stopChatting(void);

	// Sing
	void sing(LRFSong *song);
	void stopSinging(void);

	// Inputs
	void enableInputs(void);
	void disableInputs(void);

	// Outputs
	void enableOutputs(void);
	void disableOutputs(void);

	// Events
	void enableEvents(void);
	void disableEvents(void);
	void fireEvent(LRFEvent event);
	void setEventHandler(LRFEvent event, LRFEventHandler handler);
	void clearEventHandler(LRFEvent event);

	// Event Expressions
	void enableEventExpressions(void);
	void disableEventExpressions(void);
	void setEventExpression(LRFEvent event, LRFExpressionName name);

	// Expressive Eyes
	void enableExpressiveEyes(void);
	void disableExpressiveEyes(void);

	// Tricks
	void enableTricks(void);
	void disableTricks(void);
	void setTrick(LRFFunctionPtr setup, LRFFunctionPtr loop, LRFFunctionPtr cleanup=NULL);
	void clearTrick();
	void performTrick();
	void exitTrick();


private:
	// nothing right now
};

extern LittleRobotFriends lrf;



#endif
