
#include "LittleRobotFriends.h"

LittleRobotFriends lrf;

LittleRobotFriends::LittleRobotFriends(void)
{
	// placeholder for future constructor
}

void LittleRobotFriends::setup(void)
{
	// setup our lrf system
	lrf_system_init();
}

void LittleRobotFriends::loop(void)
{
	// run our system process
	lrf_system_process();
}

// Future implementation
// void LittleRobotFriends::wake(void)
// {
//
// }
//
// void LittleRobotFriends::sleep(void)
// {
//
// }
//
// void LittleRobotFriends::reset(void)
// {
//
// }

void LittleRobotFriends::setBoredomTimer(unsigned int seconds)
{
	lrf_events_setBoredomTimer(seconds);
}

//------------------------------------------------------------
// Character
//------------------------------------------------------------

void LittleRobotFriends::getName(String *name)
{

}

void LittleRobotFriends::setName(String name)		// make a pointer?
{

}

//------------------------------------------------------------
// Inputs & Outputs
//------------------------------------------------------------

// Inputs
void LittleRobotFriends::enableInputs(void)
{
	lrf_senses.enabled = true;
}

void LittleRobotFriends::disableInputs(void)
{
	lrf_senses.enabled = false;
}

// Outputs
void LittleRobotFriends::enableOutputs(void)
{
	// TODO
}

void LittleRobotFriends::disableOutputs(void)
{
	// TODO
}


//------------------------------------------------------------
// Expressions
//------------------------------------------------------------

void LittleRobotFriends::blinkAndSay(LRFExpression *expression, bool blocking)
{
	(blocking) ? lrf_expressions_blinkAndSayBlocking(expression) : lrf_expressions_blinkAndSay(expression);
}

void LittleRobotFriends::blinkAndSayPreset(LRFExpressionName name, bool blocking)
{
	(blocking) ? lrf_expressions_blinkAndSayPresetBlocking(name) : lrf_expressions_blinkAndSayPreset(name);
}

void LittleRobotFriends::setExpressionPreset(LRFExpressionName name, LRFExpression *expression)
{
	lrf_character_setExpressionPreset(name, expression);
}

bool LittleRobotFriends::isExpressing(void)
{
	if(lrf_expressions.state == LRFExpressionState_Idle)
	{
		return false;
	}
	else
	{
		return true;
	}
}

//------------------------------------------------------------
// Chatting & Singing
//------------------------------------------------------------

void LittleRobotFriends::chat(void)
{
	lrf_expressions_chatter();
}

void LittleRobotFriends::stopChatting(void)
{
	// TODO: make chatting non-blocking
	//lrf_expressions_stopChatting();
}

void LittleRobotFriends::sing(LRFSong *song)
{
	lrf_expressions_sing(song);
}

void LittleRobotFriends::stopSinging(void)
{
	// TODO: make singing non-blocking
	//lrf_expressions_stopSinging();
}

//------------------------------------------------------------
// Events
//------------------------------------------------------------

void LittleRobotFriends::enableEvents(void)
{
	lrf_events_enable();
}

void LittleRobotFriends::disableEvents(void)
{
	lrf_events_disable();
}

void LittleRobotFriends::fireEvent(LRFEvent event)
{
	lrf_events_fire(event);
}

void LittleRobotFriends::setEventHandler(LRFEvent event, LRFEventHandler handler)
{
	lrf_events_set(event, handler);
}

void LittleRobotFriends::clearEventHandler(LRFEvent event)
{
	lrf_events_set(event, &lrf_events_default_handler);
}

void LittleRobotFriends::enableEventExpressions(void)
{
	lrf_events.expressionsEnabled = true;
}

void LittleRobotFriends::disableEventExpressions(void)
{
	lrf_events.expressionsEnabled = false;
}

void LittleRobotFriends::setEventExpression(LRFEvent event, LRFExpressionName name)
{
	lrf_character_setEventMapping(event, name);
}

// Expressive Eyes
void LittleRobotFriends::enableExpressiveEyes(void)
{
	lrf_expressions_enableExpressiveEyes();
}

void LittleRobotFriends::disableExpressiveEyes(void)
{
	lrf_expressions_disableExpressiveEyes();
}

void LittleRobotFriends::setTrick(LRFFunctionPtr setup, LRFFunctionPtr loop, LRFFunctionPtr cleanup)
{
	lrf_character.trick.setup = setup;
	lrf_character.trick.loop = loop;
	lrf_character.trick.cleanup = cleanup;
}

void LittleRobotFriends::clearTrick()
{
	lrf_character.trick.setup = NULL;
	lrf_character.trick.loop = NULL;
	lrf_character.trick.cleanup = NULL;
}

void LittleRobotFriends::performTrick()
{
	lrf_tricks_run(LRFTrick_Character);
}

void LittleRobotFriends::exitTrick()
{
	lrf_tricks_exit();
}

void LittleRobotFriends::enableTricks(void){
	lrf_tricks.enabled = true;
}

void LittleRobotFriends::disableTricks(void){
	lrf_tricks.enabled = false;
}
