
#include <LittleRobotFriends.h>

// using SOUNDS is a way to control the speaker using musical notes (A, B, C...)

// two ways to make a sound

// 1) longform
LRFSound mySound = {
  .note = LRFNote_A,
  .octave = LRFOctave_3,
  .intonation = LRFIntonation_Flat,
  .duration = LRFDuration_Long,
  .pause = LRFDuration_None
};

// 2) shortform
LRFSound myOtherSound = { LRFNote_C, LRFOctave_4, LRFIntonation_Rising, LRFDuration_DoubleMedium, LRFDuration_None };

bool soundToggle = false;

// ------------------------------
// Setup & Loop
// ------------------------------

void setup()
{
  // set up our library
  lrf.setup();
}

void loop()
{
  // run our library loop
  lrf.loop();

  // say our sounds (true == blocking)
  if(soundToggle)
  {
    lrf.speech.saySound(mySound, true);
  }
  else
  {
    lrf.speech.saySound(myOtherSound, true);
  }

  // flip the value
  soundToggle = !soundToggle;

  // delay
  delay(1000);

}
